﻿#include "system_wrappers/source/trace_win.h"

#include <assert.h>
#include <stdarg.h>

#include "Mmsystem.h"

#if defined(_DEBUG)
#define BUILDMODE "d"
#elif defined(DEBUG)
#define BUILDMODE "d"
#elif defined(NDEBUG)
#define BUILDMODE "r"
#else
#define BUILDMODE "?"
#endif
#define BUILDTIME __TIME__
#define BUILDDATE __DATE__
// Example: "Oct 10 2002 12:05:30 r"
#define BUILDINFO BUILDDATE " " BUILDTIME " " BUILDMODE

#ifdef _WIN32
#pragma warning(disable: 4996)
#endif // _WIN32

namespace gn
{
	TraceWindows::TraceWindows()
		: prev_api_tick_count_(0),
		prev_tick_count_(0)
	{
	}

	TraceWindows::~TraceWindows()
	{
		StopThread();
	}

	int32_t TraceWindows::AddTime(char* trace_message,
		const TraceLevel level) const
	{
		uint32_t dw_current_time = timeGetTime();
		SYSTEMTIME system_time;
		GetSystemTime(&system_time);

		if (level == kTraceApiCall)
		{
			uint32_t dw_delta_time = dw_current_time - prev_tick_count_;
			prev_tick_count_ = dw_current_time;

			if (prev_tick_count_ == 0)
			{
				dw_delta_time = 0;
			}
			if (dw_delta_time > 0x0fffffff)
			{
				// Either wrap-around or data race.
				dw_delta_time = 0;
			}
			if (dw_delta_time > 99999)
			{
				dw_delta_time = 99999;
			}

			sprintf(trace_message, "(%02u:%02u:%02u:%03u |%05lu) ", system_time.wHour,
				system_time.wMinute, system_time.wSecond,
				system_time.wMilliseconds, dw_delta_time);
		}
		else 
		{
			uint32_t dw_delta_time = dw_current_time - prev_api_tick_count_;
			prev_api_tick_count_ = dw_current_time;

			if (prev_api_tick_count_ == 0)
			{
				dw_delta_time = 0;
			}
			if (dw_delta_time > 0x0fffffff)
			{
				// Either wraparound or data race.
				dw_delta_time = 0;
			}
			if (dw_delta_time > 99999)
			{
				dw_delta_time = 99999;
			}
			sprintf(trace_message, "(%02u:%02u:%02u:%03u |%05lu) ", system_time.wHour,
				system_time.wMinute, system_time.wSecond,
				system_time.wMilliseconds, dw_delta_time);
		}
		return 22;
	}

	int32_t TraceWindows::AddBuildInfo(char* trace_message) const
	{
		// write data and time to text file
		sprintf(trace_message, "Build info: %s", BUILDINFO);
		// Include NULL termination (hence + 1).
		return static_cast<int32_t>(strlen(trace_message) + 1);
	}

	int32_t TraceWindows::AddDateTimeInfo(char* trace_message) const
	{
		prev_api_tick_count_ = timeGetTime();
		prev_tick_count_ = prev_api_tick_count_;

		SYSTEMTIME sys_time;
		GetLocalTime(&sys_time);

		char sz_date_str[20];
		char sz_time_str[20];

		// Create date string (e.g. Apr 04 2002)
		GetDateFormatA(LOCALE_SYSTEM_DEFAULT, 0, &sys_time, "yyyy/MM/dd",
			sz_date_str, 20);

		// Create time string (e.g. 15:32:08)
		GetTimeFormatA(LOCALE_SYSTEM_DEFAULT, 0, &sys_time, "HH':'mm':'ss",
			sz_time_str, 20);

		sprintf(trace_message, "Local Date: %s Local Time: %s", sz_date_str,
			sz_time_str);

		// Include NULL termination (hence + 1).
		return static_cast<int32_t>(strlen(trace_message) + 1);
	}

}  // namespace gn

#ifdef _WIN32
#pragma warning(default: 4996)
#endif // _WIN32

